<?php

namespace App\Console\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AdsCreate;
use App\Models\AdsList;
use App\Services\YandexApiServices;

class GetAdsController extends Controller
{
    public function get_array_ads_from_api()
    {
        $ads_lists = AdsList::pluck('id');
        foreach ($ads_lists as $ads_list) {
            $value = YandexApiServices::get_object_yandex_direct(array("Ids" => [$ads_list]), ['Id'], '/ads',  ["AdImageHash", "LogoExtensionHash", "LogoExtensionModeration", "DisplayDomain", "Href", "SitelinkSetId", "Text", "Title", "Title2", "Mobile", "VCardId", "DisplayUrlPath", "DutPrefix", "DutSuffix", "AdImageModeration", "SitelinksModeration", "VCardModeration", "AdExtensions", "DisplayUrlPathModeration", "VideoExtension", "TurboPageId", "TurboPageModeration", "ButtonExtensionModeration", "BusinessId", "TrackingPhoneId", "PreferVCardOverBusiness", "ButtonExtension"]);
            if($value['result'] !== []) {
                $value_arr_ads_lists[] = $value;
            }
        }
        return $value_arr_ads_lists;
    }

    public function get_ads_from_api()
    {
        foreach ($this->get_array_ads_from_api() as $value_arr_ads) {
            foreach ($value_arr_ads['result']['Ads'] as $lists) {
                $data_value_arr_ads[] = $lists;
            }
        }
        return $data_value_arr_ads;
    }

    public function format_ad_data(): array
    {
        foreach ($this->get_ads_from_api() as $lists) {
            $value_arr_ad[] = [
                'ads_list_id' => $lists['Id'],
                'text' => $lists['TextAd']['Text'],
                'title' => $lists['TextAd']['Title'],
                'title2' => $lists['TextAd']['Title2'],
                'href' => $lists['TextAd']['Href'],
                'mobile' => $lists['TextAd']['Mobile'],
                'v_card_id' => $lists['TextAd']['VCardId'],
                "ad_image_hash" => $lists['TextAd']['AdImageHash'],
                "logo_extension_hash" => $lists['TextAd']['LogoExtensionHash'],
                "logo_extension_moderation" => $lists['TextAd']['LogoExtensionModeration'],
                "display_domain" => $lists['TextAd']['DisplayDomain'],
                "sitelink_set_id" => $lists['TextAd']['SitelinkSetId'],
                "display_url_path" => $lists['TextAd']['DisplayUrlPath'],
                "dut_prefix" => $lists['TextAd']['DutPrefix'],
                "dut_suffix" => $lists['TextAd']['DutSuffix'],
                "ad_image_moderation" => $lists['TextAd']['AdImageModeration'],
                "sitelinks_moderation" => $lists['TextAd']['SitelinksModeration'],
                "v_card_moderation_status" => $lists['TextAd']['VCardModeration']['Status'],
                "v_card_moderation_status_clarification" => $lists['TextAd']['VCardModeration']['StatusClarification'],
                "display_url_path_moderation" => $lists['TextAd']['DisplayUrlPathModeration'],
                "video_extension" => $lists['TextAd']['VideoExtension'],
                "turbo_page_id" => $lists['TextAd']['TurboPageId'],
                "turbo_page_moderation" => $lists['TextAd']['TurboPageModeration'],
                "button_extension_moderation" => $lists['TextAd']['ButtonExtensionModeration'],
                "business_id" => $lists['TextAd']['BusinessId'],
                "tracking_phone_id" => $lists['TextAd']['TrackingPhoneId'],
                'prefer_v_card_over_business' => $lists['TextAd']['PreferVCardOverBusiness'],
                "button_extension" => $lists['TextAd']['ButtonExtension'],
            ];
        }

        return $value_arr_ad;
    }

    public function send_api_ads() {
        return response()->json($this->format_ad_data());
    }

    public function __invoke()
    {
        AdsCreate::upsert($this->format_ad_data(), ['id'], [
            'title',
            'text',
            'href',
            'v_card_id',
            "ad_image_hash",
            "logo_extension_hash",
            "logo_extension_moderation",
            "display_domain",
            "sitelink_set_id",
            "title2",
            "mobile",
            "display_url_path",
            "dut_prefix",
            "dut_suffix",
            "ad_image_moderation",
            "sitelinks_moderation",
            "v_card_moderation_status",
            "v_card_moderation_status_clarification",
            "display_url_path_moderation",
            "video_extension",
            "turbo_page_id",
            "turbo_page_moderation",
            "button_extension_moderation",
            "business_id",
            "tracking_phone_id",
            'prefer_v_card_over_business',
            "button_extension",
        ]);
    }
}
