<?php

namespace App\Console\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AdsGroup;
use App\Models\Campaign;
use App\Models\NegativeKeywordsGroup;
use App\Services\YandexApiServices;
use Illuminate\Support\Carbon;

class GetAdsGroupController extends Controller
{
    public function get_raw_array_ads_groups_from_api()
    {
        $campaigns = Campaign::pluck('id');
        foreach ($campaigns as $campaign) {
            $value_arr_campaigns[] = YandexApiServices::get_object_yandex_direct_where_text_ad_field_names(array("CampaignIds" => [$campaign]), ["Id", "Name", "Status", "CampaignId", "RegionIds", "RestrictedRegionIds", "NegativeKeywords", "NegativeKeywordSharedSetIds", "Type", "TrackingParams", "Subtype", "ServingStatus"], '/adgroups');
        }
        return $value_arr_ads_groups;
    }

    public function get_ads_groups_from_api()
    {
        foreach ($this->get_raw_array_ads_groups_from_api() as $value_arr_ads_groups) {
            foreach ($value_arr_ads_groups['result']['AdGroups'] as $group) {
                $data_value_arr_ads_groups[] = $group;
            }
            return $data_value_arr_ads_groups;
        }
    }

    public function get_negative_keywords_from_ads_groups_from_api()
    {
        foreach($this->get_ads_groups_from_api() as $value_arr_ads_groups) {
            $keywords = [];
            foreach ($value_arr_ads_groups['NegativeKeywords']['Items'] as $group) {
                $keywords[] = $group;
            }
            return $keywords;
        }
    }

    public function format_ads_group_data()
    {
        foreach ($this->get_ads_groups_from_api() as $group) {
            $value_arr_ads_groups[] = [
                'id' => $group['Id'],
                'campaign_id' => $group['CampaignId'],
                'name' => $group['Name'],
                'status' => $group['Status'],
                'type' => $group['Type'],
                'subtype' => $group['Subtype'],
                'serving_status' => $group['ServingStatus'],
                'restricted_region_ids' => $group['RestrictedRegionIds'],
                'region_ids' => $group['RegionIds'][0],
                'negative_keyword_shared_set_ids' => $group['NegativeKeywordSharedSetIds'],
                'tracking_params' => $group['TrackingParams'],
            ];
        }
        return $value_arr_ads_groups;
    }

    public function format_negative_keywords_ads_group_data()
    {
        $current_unix_time = time();
        foreach ($this->get_ads_groups_from_api() as $group) {
            $keywords = [];
            foreach ($this->get_negative_keywords_from_ads_groups_from_api() as $item) {
                $keywords[] = $item;
            }
            foreach ($keywords as $keyword) {
                $value_arr_negative_keywords_ads_groups[] = [
                    'current_unix_time' => $current_unix_time,
                    'campaign_id' => $group['CampaignId'],
                    'ads_group_id' => $group['Id'],
                    'negative_keyword' => $keyword,
                    'created_at' => Carbon::now()->toDateTimeString(),
                ];
            }
        }
        return $value_arr_negative_keywords_ads_groups;
    }

    public function send_api_ads_group() {
        return response()->json($this->format_ads_group_data());
    }

    public function send_api_ads_group_negative_keywords() {
        return response()->json($this->format_negative_keywords_ads_group_data());
    }

    public function __invoke()
    {
        AdsGroup::upsert($this->format_ads_group_data(), ['id'], [
                'campaign_id',
                'name',
                'status',
                'type',
                'subtype',
                'serving_status',
                'restricted_region_ids',
                'region_ids',
                'negative_keyword_shared_set_ids',
                'tracking_params',
            ]);
        NegativeKeywordsGroup::insert($this->format_negative_keywords_ads_group_data());
    }
}
