<?php

namespace App\Console\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AdsList;
use App\Models\AdsGroup;
use App\Services\YandexApiServices;

class GetAdsListController extends Controller
{

    public function get_array_ads_lists_from_api(): array
    {
        $ads_groups = AdsGroup::pluck('id');
        foreach ($ads_groups as $ads_group) {
            $value_arr_ads_lists[] = YandexApiServices::get_object_yandex_direct_where_text_ad_field_names(array("AdGroupIds" => [$ads_group]), ['Id', 'State', "Status", "Type", "AdCategories", "AgeLabel", "AdGroupId", "CampaignId", "StatusClarification", "Subtype"], '/ads');
        }
        return $value_arr_ads_lists;
    }

    public function get_ads_lists_from_api(): array
    {
        foreach ($this->get_array_ads_lists_from_api() as $value_arr_ads_lists) {
            foreach ($value_arr_ads_lists['result']['Ads'] as $group) {
                $data_value_arr_ads_lists[] = $group;
            }
        }
        return $data_value_arr_ads_lists;
    }

    public function format_ads_list_data(): array
    {
        foreach ($this->get_ads_lists_from_api() as $lists) {
            $value_arr_ads_lists[] = [
                'id' => $lists['Id'],
                'ads_group_id' => $lists['AdGroupId'],
                'state' => $lists['State'],
                'status' => $lists['Status'],
                'type' => $lists['Type'],
                'ad_categories' => $lists['AdCategories'],
                'age_label' => $lists['AgeLabel'],
                'campaign_id' => $lists['CampaignId'],
                'status_clarification' => $lists['StatusClarification'],
                'subtype' => $lists['Subtype'],
            ];
        }
        return $value_arr_ads_lists;
    }

    public function send_api_ads_list() {
        return response()->json($this->format_ads_list_data());
    }

    public function __invoke()
    {
        AdsList::upsert($this->format_ads_list_data(), ['id'],
            [
                'ads_group_id',
                'state',
                'status',
                'type',
                "ad_categories",
                "age_label",
                "campaign_id",
                "status_clarification",
                "subtype"
            ]);
    }
}

