<?php

namespace App\Console\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Campaign;
use App\Models\NegativeKeywords;
use App\Services\YandexApiServices;
use Illuminate\Support\Carbon;

class GetCampaignListController extends Controller
{
    public function get_raw_array_campaigns_list_from_api()
    {
        return YandexApiServices::get_object_yandex_direct_where_text_ad_field_names((object)array(), ['Id', 'Name', "BlockedIps", "ExcludedSites", "Currency", "DailyBudget", "Notification", "EndDate", "Funds", "ClientInfo", "NegativeKeywords", "RepresentedBy", "StartDate", "Statistics", "State", "Status", "StatusPayment", "StatusClarification", "SourceId", "TimeTargeting", "TimeZone", "Type"], '/campaigns');
    }

    public function get_campaigns_from_api(): array
    {
        $result = [];
        foreach ($this->get_raw_array_campaigns_list_from_api()['result']['Campaigns'] as $item) {
            $result[] = array_change_key_case($item);
        }
        return $result;
    }

    public function format_campaigns_data()
    {
        $value_arr_campaigns = [];

        foreach ($this->get_campaigns_from_api() as $campaign) {
            $value_arr_campaigns[] = [
                'id' => $campaign['id'],
                'name' => $campaign['name'],
                'start_date' => $campaign['startdate'],
                'type' => $campaign['type'],
                'status' => $campaign['status'],
                'state' => $campaign['state'],
                'status_payment' => $campaign['statuspayment'],
                'status_clarification' => $campaign['statusclarification'],
                'source_id' => $campaign['sourceid'],
                'clicks' => $campaign['statistics']['Clicks'],
                'impressions' => $campaign['statistics']['Impressions'],
                'currency' => $campaign['currency'],
                'mode' => $campaign['funds']['Mode'],
                'sum' => $campaign['funds']['CampaignFunds']['Sum'],
                'balance' => $campaign['funds']['CampaignFunds']['Balance'],
                'balance_bonus' => $campaign['funds']['CampaignFunds']['BalanceBonus'],
                'sum_available_for_transfer' => $campaign['funds']['CampaignFunds']['SumAvailableForTransfer'],
                'manager' => $campaign['representedby']['Manager'],
                'agency' => $campaign['representedby']['Agency'],
                'daily_budget' => $campaign['dailybudget'],
                'end_date' => $campaign['enddate'],
                'blocked_ips' => $campaign['blockedips'],
                'excluded_sites' => $campaign['excludedsites'],
                'holidays_schedule' => $campaign['timetargeting']['HolidaysSchedule'],
                'monday' => $campaign['timetargeting']['Schedule']['Items'][0],
                'tuesday' => $campaign['timetargeting']['Schedule']['Items'][1],
                'wednesday' => $campaign['timetargeting']['Schedule']['Items'][2],
                'thursday' => $campaign['timetargeting']['Schedule']['Items'][3],
                'friday' => $campaign['timetargeting']['Schedule']['Items'][4],
                'saturday' => $campaign['timetargeting']['Schedule']['Items'][5],
                'sunday' => $campaign['timetargeting']['Schedule']['Items'][6],
                'consider_working_weekends' => $campaign['timetargeting']['ConsiderWorkingWeekends'],
                'client_info' => $campaign['clientinfo'],
                'sms_time_from' => $campaign['notification']['SmsSettings']['TimeFrom'],
                'sms_time_to' => $campaign['notification']['SmsSettings']['TimeTo'],
                'email' => $campaign['notification']['EmailSettings']['Email'],
                'check_position_interval' => $campaign['notification']['EmailSettings']['CheckPositionInterval'],
                'warning_balance' => $campaign['notification']['EmailSettings']['WarningBalance'],
                'send_account_news' => $campaign['notification']['EmailSettings']['SendAccountNews'],
                'send_warnings' => $campaign['notification']['EmailSettings']['SendWarnings'],
                'time_zone' => $campaign['timezone'],
            ];
        }
        return $value_arr_campaigns;
    }

    public function format_negative_keywords_data()
    {
        $current_unix_time = time();

        foreach ($this->get_campaigns_from_api() as $campaign) {
            $keywords = [];

            foreach ($campaign['negativekeywords']['Items'] as $item) {
                $keywords[] = $item;
            }

            foreach ($keywords as $keyword) {
                $negative_keywords_value_arr[] = [
                    'current_unix_time' => $current_unix_time,
                    'campaign_id' => $campaign['id'],
                    'negative_keywords' => $keyword,
                    'created_at' => Carbon::now()->toDateTimeString(),
                ];
            }
        }
        return $negative_keywords_value_arr;
    }

    public function send_api_campaign() {
        return response()->json($this->format_campaigns_data());
    }

    public function send_api_campaign_negative_keywords() {
        return response()->json($this->format_negative_keywords_data());
    }


    public function __invoke()
    {
        Campaign::upsert($this->format_campaigns_data(),['id'], [
            'name',
            'start_date',
            'type',
            'status',
            'state',
            'status_payment',
            'status_clarification',
            'source_id',
            'clicks',
            'impressions',
            'currency',
            'mode',
            'sum' ,
            'balance' ,
            'balance_bonus' ,
            'sum_available_for_transfer',
            'manager',
            'agency',
            'daily_budget',
            'end_date',
            'blocked_ips',
            'excluded_sites',
            'holidays_schedule',
            'monday',
            'tuesday',
            'wednesday',
            'thursday',
            'friday',
            'saturday',
            'sunday',
            'consider_working_weekends',
            'client_info',
            'sms_time_from',
            'sms_time_to',
            'email',
            'check_position_interval',
            'warning_balance',
            'send_account_news',
            'send_warnings',
            'time_zone',
        ]);

        NegativeKeywords::insert($this->format_negative_keywords_data());
    }
}
