<?php

namespace App\Console\Controllers;

use App\Http\Controllers\Controller;
use App\Models\AdsGroup;
use App\Models\Keywords;
use Illuminate\Support\Facades\Http;

class GetKeywordsController extends Controller
{
    public function get_keywords()
    {
        $groups = AdsGroup::pluck('id');
        $response = Http::withToken(config('api.token'))->post(config('api.url') . '/keywords',
            [
                'method' => 'get',
                'params' => array(
                    'SelectionCriteria' => array("AdGroupIds" => $groups),
                    'FieldNames' => array("Id", "Keyword", "State", "Status", "AdGroupId", "CampaignId", "Bid", "ContextBid", "StrategyPriority", "UserParam1", "UserParam2", "Productivity", "StatisticsSearch", "StatisticsNetwork", "ServingStatus",),
                )
            ])->json();

        if($response['result'] == null) {
            return null;
        }
        else {
            $result = [];
            foreach ($response['result']['Keywords'] as $keywords) {
                $result[] = [
                    'id' => $keywords['Id'],
                    'ads_group_id' => $keywords['AdGroupId'],
                    'keyword' => $keywords['Keyword'],
                    'bid' => $keywords['Bid'],
                    'state' => $keywords['State'],
                    'status' => $keywords['Status'],
                    "campaign_id" => $keywords['CampaignId'],
                    "context_bid" => $keywords['ContextBid'],
                    "strategy_priority" => $keywords['StrategyPriority'],
                    "user_param1" => $keywords['UserParam1'],
                    "user_param2" => $keywords['UserParam2'],
                    "productivity" => $keywords['Productivity'],
                    "statistics_search_clicks" => $keywords['StatisticsSearch']['Clicks'],
                    "statistics_search_impressions" => $keywords['StatisticsSearch']["Impressions"],
                    "statistics_network_clicks" => $keywords['StatisticsNetwork']['Clicks'],
                    "statistics_network_impressions" => $keywords['StatisticsNetwork']["Impressions"],
                    "serving_status" => $keywords['ServingStatus'],
                ];
            }
            return $result;
        }
    }

    public function send_api_keywords() {
        return response()->json($this->get_keywords());
    }

    public function __invoke()
    {
        Keywords::upsert($this->get_keywords(), ['id'],
            [
                'ads_group_id',
                'keyword',
                'bid',
                'state',
                'status',
                "campaign_id",
                "context_bid",
                "strategy_priority",
                "user_param1",
                "user_param2",
                "productivity",
                "statistics_search_clicks",
                "statistics_search_impressions",
                "statistics_network_clicks",
                "statistics_network_impressions",
                "serving_status",
            ]
        );
    }
}
