<?php

namespace App\Console;

use App\Console\Controllers\GetAdsController;
use App\Console\Controllers\GetAdsGroupController;
use App\Console\Controllers\GetAdsListController;
use App\Console\Controllers\GetCampaignListController;
use App\Console\Controllers\GetKeywordsController;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule): void
    {
//         $schedule->command('inspire')->hourly();
        $schedule->call(new GetCampaignListController())->everyMinute()->appendOutputTo('scheduler.log');
        $schedule->call(new GetAdsGroupController())->everyTenMinutes()->appendOutputTo('scheduler.log');
        $schedule->call(new GetAdsListController())->everyTenMinutes()->appendOutputTo('scheduler.log');
        $schedule->call(new GetAdsController())->everyTenMinutes()->appendOutputTo('scheduler.log');
        $schedule->call(new GetKeywordsController())->everyTenMinutes()->appendOutputTo('scheduler.log');

    }

    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
