<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class AdsCreate extends Model
{
    protected $fillable = [
        'id',
        'ads_list_id',
        'title',
        'text',
        'href',
        'v_card_id',
        'ad_image_hash',
        'logo_extension_hash',
        "logo_extension_moderation",
        "display_domain",
        "sitelink_set_id",
        "title2",
        "mobile",
        "display_url_path",
        "dut_prefix",
        "dut_suffix",
        "ad_image_moderation",
        "sitelinks_moderation",
        "v_card_moderation_status",
        "v_card_moderation_status_clarification",
        "display_url_path_moderation",
        "video_extension",
        "turbo_page_id",
        "turbo_page_moderation",
        "button_extension_moderation",
        "business_id",
        "tracking_phone_id",
        "prefer_v_card_over_business",
        "button_extension",
    ];

    public function ads_lists(): BelongsTo
    {
        return $this->belongsTo(AdsList::class, 'ads_list_id');
    }
}
