<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class AdsGroup extends Model
{
    protected $fillable = [
        'id',
        'campaign_id',
        'name',
        'status',
        'type',
        'subtype',
        'serving_status',
        'restricted_region_ids',
        'region_ids',
        'negative_keyword_shared_set_ids',
        'tracking_params'
    ];

    public function keywords(): HasMany
    {
        return $this->hasMany(Keywords::class, 'ads_group_id');
    }

    public function negative_keywords_group(): HasMany
    {
        return $this->hasMany(NegativeKeywordsGroup::class);
    }

    public function campaign(): BelongsTo
    {
        return $this->belongsTo(Campaign::class);
    }

    public function ads_list(): HasOne
    {
        return $this->hasOne(AdsList::class);
    }

    public function ads_create(): HasManyThrough
    {
        return $this->hasManyThrough(AdsCreate::class, AdsList::class);
    }
}

