<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AdsList extends Model
{
    protected $fillable = [
        'id',
        'ads_group_id',
        'state',
        'status',
        'type',
        "ad_categories",
        "age_label",
        "campaign_id",
        "status_clarification",
        "subtype"
    ];

    public function ads_group(): BelongsTo
    {
        return $this->belongsTo(AdsGroup::class);
    }

    public function ads_create(): HasMany
    {
        return $this->hasMany(AdsCreate::class);
    }
}
