<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Campaign extends Model
{
    protected $fillable = [
        'id',
        'name',
        'start_date',
        'type',
        'status',
        'state',
        'status_payment',
        'status_clarification',
        'source_id',
        'clicks',
        'impressions',
        'currency',
        'mode',
        'sum',
        'balance',
        'balance_bonus',
        'sum_available_for_transfer',
        'manager',
        'agency',
        'daily_budget',
        'end_date',
        'blocked_ips',
        'excluded_sites',
        'holidays_schedule',
        'monday',
        'tuesday',
        'wednesday',
        'thursday',
        'friday',
        'saturday',
        'sunday',
        'client_info',
        'sms_time_from',
        'sms_time_to',
        'email',
        'check_position_interval',
        'warning_balance',
        'send_account_news',
        'send_warnings',
        'time_zone',
    ];

    public function keywords(): HasMany
    {
        return $this->hasMany(Keywords::class);
    }
}
