<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Keywords extends Model
{
    protected $fillable = [
        'ads_group_id',
        'keyword',
        'bid',
        'state',
        'status',
        "campaign_id",
        "context_bid",
        "strategy_priority",
        "user_param1",
        "user_param2",
        "productivity",
        "statistics_search_clicks",
        "statistics_search_impressions",
        "statistics_network_clicks",
        "statistics_network_impressions",
        "serving_status",
    ];

    public function ads_group(): BelongsTo
    {
        return $this->belongsTo(AdsGroup::class);
    }

    public function campaign(): BelongsTo
    {
       return $this->belongsTo(Campaign::class);
    }
}


