<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NegativeKeywordsGroup extends Model
{
    protected $fillable = [
        'id',
        'current_unix_time',
        'campaign_id',
        'ads_group_id',
        'negative_keyword',
    ];

    public function ads_group(): BelongsTo
    {
        return $this->belongsTo(AdsGroup::class);
    }
    public function campaign(): BelongsTo
    {
        return $this->belongsTo(Campaign::class);
    }
}
