<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('campaigns', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->dateTime('start_date');
            $table->string('type');
            $table->string('status');
            $table->string('state');
            $table->string('status_payment');
            $table->string('status_clarification');
            $table->integer('source_id')->nullable();
            $table->integer('clicks');
            $table->integer('impressions');
            $table->string('currency');
            $table->string('mode');
            $table->bigInteger('sum');
            $table->bigInteger('balance');
            $table->integer('balance_bonus');
            $table->bigInteger('sum_available_for_transfer');
            $table->string('manager')->nullable();
            $table->string('agency')->nullable();
            $table->bigInteger('daily_budget')->nullable();
            $table->dateTime('end_date')->nullable();
            $table->integer('blocked_ips')->nullable();
            $table->string('excluded_sites')->nullable();
            $table->integer('holidays_schedule')->nullable();
            $table->string('monday');
            $table->string('tuesday');
            $table->string('wednesday');
            $table->string('thursday');
            $table->string('friday');
            $table->string('saturday');
            $table->string('sunday');
            $table->string('consider_working_weekends');
            $table->string('client_info');
            $table->string('sms_time_from');
            $table->string('sms_time_to');
            $table->string('email');
            $table->integer('check_position_interval');
            $table->integer('warning_balance');
            $table->string('send_account_news');
            $table->string('send_warnings');
            $table->string('time_zone');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('campaigns');
    }
};
