<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ads_creates', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ads_list_id');
            $table->string('title');
            $table->string('text');
            $table->string('href');
            $table->integer('v_card_id');
            $table->string("ad_image_hash")->nullable();
            $table->string("logo_extension_hash")->nullable();
            $table->string("logo_extension_moderation")->nullable();
            $table->string("display_domain");
            $table->integer("sitelink_set_id")->nullable();
            $table->string("title2")->nullable();
            $table->string("mobile");
            $table->string("display_url_path")->nullable();
            $table->string("dut_prefix")->nullable();
            $table->string("dut_suffix")->nullable();
            $table->string("ad_image_moderation")->nullable();
            $table->string("sitelinks_moderation")->nullable();
            $table->string("v_card_moderation_status");
            $table->string("v_card_moderation_status_clarification");
            $table->string("display_url_path_moderation")->nullable();
            $table->string("video_extension")->nullable();
            $table->integer("turbo_page_id")->nullable();
            $table->string("turbo_page_moderation")->nullable();
            $table->string("button_extension_moderation")->nullable();
            $table->integer("business_id")->nullable();
            $table->integer("tracking_phone_id")->nullable();
            $table->string("prefer_v_card_over_business");
            $table->string("button_extension")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads_creates');
    }
};
