<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('ads_groups', function (Blueprint $table) {
            $table->id();
            $table->foreignId('campaign_id');
            $table->string('name');
            $table->string('status');
            $table->string('type');
            $table->string('subtype');
            $table->string('serving_status');
            $table->string('restricted_region_ids')->nullable();
            $table->integer('region_ids');
            $table->integer('negative_keyword_shared_set_ids')->nullable();
            $table->string('tracking_params');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('ads_groups');
    }
};
