<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ads_lists', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ads_group_id');
            $table->string('state');
            $table->string('status');
            $table->string('type');
            $table->foreignId('campaign_id');
            $table->string('status_clarification');
            $table->string('ad_categories')->nullable();
            $table->string('age_label')->nullable();
            $table->string('subtype');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ads_lists');
    }
};
