<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('keywords', function (Blueprint $table) {
            $table->id();
            $table->integer('ads_group_id');
            $table->string('keyword');
            $table->integer('bid');
            $table->string('state');
            $table->string('status');
            $table->integer("campaign_id");
            $table->integer("context_bid");
            $table->string("strategy_priority");
            $table->string("user_param1")->nullable();
            $table->string("user_param2")->nullable();
            $table->string("productivity")->nullable();
            $table->integer("statistics_search_clicks");
            $table->integer("statistics_search_impressions");
            $table->integer("statistics_network_clicks");
            $table->integer("statistics_network_impressions");
            $table->string("serving_status");
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('keywords');
    }
};
