<?php

use App\Console\Controllers\GetAdsController;
use App\Console\Controllers\GetAdsGroupController;
use App\Console\Controllers\GetAdsListController;
use App\Console\Controllers\GetCampaignListController;
use App\Console\Controllers\GetKeywordsController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request)
{
    return $request->user();
});
Route::get('/format_campaigns_data', [GetCampaignListController::class, 'send_api_campaign']);
Route::get('/format_negative_keywords_data', [GetCampaignListController::class, 'send_api_campaign_negative_keywords']);
Route::get('/format_ad_data', [GetAdsController::class, 'send_api_ads']);
Route::get('/format_ads_group_data', [GetAdsGroupController::class, 'send_api_ads_group']);
Route::get('/format_negative_keywords_ads_group_data', [GetAdsGroupController::class, 'send_api_ads_group_negative_keywords']);
Route::get('/format_ads_list_data', [GetAdsListController::class, 'send_api_ads_list']);
Route::get('/get_keywords', [GetKeywordsController::class, 'send_api_keywords']);

