<?php

namespace Tests\Unit;

use App\Models\AdsGroup;
use App\Models\AdsCreate;
use App\Models\AdsList;
use App\Models\Campaign;
use App\Models\Keywords;
use App\Models\NegativeKeywordsGroup;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;

class AdsGroupTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */

    public function test_ads_group_database_has_expected_columns()
    {
        /** @test  */
        $this->assertTrue(
            Schema::hasColumns('ads_groups',
                [
                    'id',
                    'campaign_id',
                    'name',
                    'status',
                    'type',
                    'subtype',
                    'serving_status',
                    'restricted_region_ids',
                    'region_ids',
                    'negative_keyword_shared_set_ids',
                    'tracking_params',
                ])
        );
    }

    public function test_attribute_belongs_to_many_campaign(): void
    {
        /** @test  */
        $parent = new AdsGroup();
        $this->assertBelongsToUsing(Campaign::class, $parent->campaign(), 'campaign_id');
    }

    public function test_attribute_has_many_keywords(): void
    {
        /** @test  */
        $child = new AdsGroup();
        $this->assertHasManyUsing(Keywords::class, $child->keywords(), 'ads_group_id');
    }

    public function test_attribute_has_many_negative_keywords():void
    {
        /** @test  */
        $child = new AdsGroup();
        $this->assertHasManyUsing(NegativeKeywordsGroup::class, $child->negative_keywords_group(), 'ads_group_id');
    }

    public function test_attribute_has_one_ads_list():void
    {
        /** @test  */
        $parent = new AdsGroup();
        $this->assertHasOneUsing(AdsList::class,$parent->ads_list(), 'ads_group_id');
    }

    public function test_attribute_has_one_through_ads_create():void
    {
        /** @test  */
        $parent = new AdsGroup();
        $this->assertHasManyThroughUsing(AdsCreate::class, $parent->ads_create(), 'ads_list_id');
    }

}
