<?php

namespace Tests\Unit;

use App\Models\AdsCreate;
use App\Models\AdsGroup;
use App\Models\AdsList;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;

class AdsListTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_ads_lists_database_has_expected_columns()
    {
        /** @test */
        $this->assertTrue(
            Schema::hasColumns('ads_lists',
                [
                    'id',
                    'ads_group_id',
                    'state',
                    'status',
                    'type',
                    "ad_categories",
                    "age_label",
                    "campaign_id",
                    "status_clarification",
                    "subtype",
                ])
        );
    }
        public function test_attribute_belongs_to_ads_group()
        {
            $parent = new AdsList();
            $this->assertBelongsToUsing(AdsGroup::class, $parent->ads_group(), 'ads_group_id');

        }

        public function test_attribute_has_many_ads_create():void
        {
            /** @test  */
            $parent = new AdsList();
            $this->assertHasManyUsing(AdsCreate::class, $parent->ads_create(), 'ads_list_id');
        }

}
