<?php

namespace Tests\Unit;

use App\Models\AdsCreate;
use App\Models\AdsList;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;

class AdsTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_ads_creates_database_has_expected_columns()
    {
        /** @test */
        $this->assertTrue(
            Schema::hasColumns('ads_creates',
            [
                'id',
                'ads_list_id',
                'title',
                'text',
                'href',
                'v_card_id',
                'ad_image_hash',
                'logo_extension_hash',
                "logo_extension_moderation",
                "display_domain",
                "sitelink_set_id",
                "title2",
                "mobile",
                "display_url_path",
                "dut_prefix",
                "dut_suffix",
                "ad_image_moderation",
                "sitelinks_moderation",
                "v_card_moderation_status",
                "v_card_moderation_status_clarification",
                "display_url_path_moderation",
                "video_extension",
                "turbo_page_id",
                "turbo_page_moderation",
                "button_extension_moderation",
                "business_id",
                "tracking_phone_id",
                "prefer_v_card_over_business",
                "button_extension",
            ]
        ));
    }
    public function test_attribute_belongs_to_ads_lists() {
        $child = new AdsCreate();
        $this->assertBelongsToUsing(AdsList::class, $child->ads_lists(), 'ads_list_id');
    }

}
