<?php

namespace Tests\Unit;

use App\Console\Controllers\GetCampaignListController;
use Tests\TestCase;


class GetCampaignControllerTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_array_function_raw_array_campaigns_list_from_api()
    {
        $currentController = new GetCampaignListController();
        $this->assertIsArray($currentController->get_raw_array_campaigns_list_from_api());
    }

    public function test_array_campaigns_from_api()
    {
        $currentController = new GetCampaignListController();
        $this->assertIsArray($currentController->get_campaigns_from_api());
    }

    public function test_array_format_campaigns_data()
    {
        $currentController = new GetCampaignListController();
        $this->assertIsArray($currentController->format_campaigns_data());
    }

    public function test_array_format_negative_keywords_data()
    {
        $currentController = new GetCampaignListController();
        $this->assertIsArray($currentController->format_negative_keywords_data());
    }

    public function test_array_structure_function_raw_array_campaigns_list_from_api()
    {
        $currentController = new GetCampaignListController();
        $this->assertArrayHasKey('result', $currentController->get_raw_array_campaigns_list_from_api());
    }
}
