<?php

namespace Tests\Unit;

use App\Models\AdsGroup;
use App\Models\Campaign;
use App\Models\Keywords;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;
use Illuminate\Database\Eloquent\Relations\HasMany;


class KeywordsTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_keywords_database_has_expected_columns()
    {
        /** @test  */
        $this->assertTrue(
            Schema::hasColumns('keywords',
            [
                'id',
                'ads_group_id',
                'keyword',
                'bid',
                'state',
                'status',
                "campaign_id",
                "context_bid",
                "strategy_priority",
                "user_param1",
                "user_param2",
                "productivity",
                "statistics_search_clicks",
                "statistics_search_impressions",
                "statistics_network_clicks",
                "statistics_network_impressions",
                "serving_status",
            ])
        );
    }
    /** @test  */
    public function test_attribute_belongs_to_many_ads_group():void {
        $parent = new Keywords();
        $this->assertBelongsToUsing(AdsGroup::class, $parent->ads_group(), 'ads_group_id');
    }
    /** @test  */
    public function test_attribute_belongs_to_many_campaign():void {
        $parent = new Keywords();
        $this->assertBelongsToUsing(Campaign::class, $parent->campaign(), 'campaign_id');
    }

}
