<?php

namespace Tests\Unit;

use App\Models\AdsGroup;
use App\Models\Campaign;
use App\Models\NegativeKeywordsGroup;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;

class NegativeKeywordsGroupTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_negative_keywords_group_database_has_expected_columns(): void
    {
        $this->assertTrue(
            Schema::hasColumns('negative_keywords_groups',
                [
                    'id',
                    'current_unix_time',
                    'campaign_id',
                    'ads_group_id',
                    'negative_keyword',
                ]
        ));
    }

    public function test_attribute_belongs_to_campaign():void
    {
        /** @test */
        $parent = new NegativeKeywordsGroup();
        $this->assertBelongsToUsing(Campaign::class, $parent->campaign(), 'campaign_id');
    }

    public function test_attribute_belongs_to_ads_group():void
    {
        /** @test */
        $parent = new NegativeKeywordsGroup();
        $this->assertBelongsToUsing(AdsGroup::class, $parent->ads_group(), 'ads_group_id');
    }
}
