<?php

namespace Tests\Unit;

use App\Models\Campaign;
use App\Models\NegativeKeywords;
use Illuminate\Support\Facades\Schema;
use Tests\TestCase;

class NegativeKeywordsTableTest extends TestCase
{
    /**
     * A basic unit test example.
     */
    public function test_negative_keywords_database_has_expected_columns(): void
    {
        $this->assertTrue(Schema::hasColumns('negative_keywords',
            [
                'id',
                'current_unix_time',
                'campaign_id',
                'negative_keywords',
            ]
        ));
    }

    public function test_attribute_has_many_campaign():void
    {
        /** @test */
        $parent = new NegativeKeywords();
        $this->assertBelongsToUsing(Campaign::class, $parent->campaign(), 'campaign_id');
    }
}
