<?php
namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\PointPlan;

class FixUnassignedPointPlans extends Command
{
protected $signature = 'pointplans:fill-managers';
protected $description = 'Проставить subgroup_manager_id в PointPlan по привязке района';

public function handle()
{
$this->info('Начинаем проставлять subgroup_manager_id…');

PointPlan::whereNull('subgroup_manager_id')
->with('point.district')
->chunk(200, function($plans) {
foreach ($plans as $plan) {
$mgrId = $plan->point->district->subgroup_manager_id;
if ($mgrId) {
$plan->subgroup_manager_id = $mgrId;
$plan->saveQuietly();
$this->line("  план #{$plan->id} → subgroup_manager_id={$mgrId}");
}
}
});

$this->info('Готово.');
}
}
