<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\RequestSet;
use App\Models\Point;

class GenerateRandomRequestsCommand extends Command
{
    protected $signature = 'request:generate-random {count=3} {points=10}';
    protected $description = 'Создание случайных заявок с указанным числом точек';

    public function handle()
    {
        $count      = (int) $this->argument('count');
        $pointsEach = (int) $this->argument('points');

        $allPointIds = Point::pluck('id')->toArray();

        if (count($allPointIds) === 0) {
            $this->warn('Нет доступных точек.');
            return Command::SUCCESS;
        }

        for ($i = 1; $i <= $count; $i++) {
            $requestName = "Заявка №R{$i}";

            // Создание заявки
            $requestSet = RequestSet::updateOrCreate(
                ['name' => $requestName],
                ['description' => "Случайная заявка #$i", 'is_template' => false]
            );

            // Выбор случайных точек
            $randomPoints = collect($allPointIds)->shuffle()->take($pointsEach)->toArray();

            $requestSet->points()->sync($randomPoints);

            $this->info("Создана $requestName. Добавлено точек: " . count($randomPoints));
        }

        return Command::SUCCESS;
    }
}
