<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\RequestSet;
use App\Models\Point;

class GenerateRequestOne extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'request:generate-one';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Создать заявку №1 с точками, у которых частота мониторинга ежемесячно (monitoring_freq = 1)';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Создание заявки №1...');

        // Создание или обновление заявки
        $requestSet = RequestSet::updateOrCreate(
            ['name' => 'Заявка №1'],
            ['description' => 'Все точки с ежемесячной частотой мониторинга', 'is_template' => false]
        );

        // Получаем точки
        $points = Point::where('monitoring_freq', 1)->pluck('id')->toArray();

        if (empty($points)) {
            $this->warn('Не найдено точек с частотой мониторинга 1');
            return Command::SUCCESS;
        }

        $requestSet->points()->sync($points);

        $this->info('Заявка №1 успешно создана. Добавлено точек: ' . count($points));

        return Command::SUCCESS;
    }
}
