<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Console\Scheduling\Schedule;
use App\Models\PointPlan;
use App\Models\User;
use Carbon\Carbon;

class NotifyOperatorsAboutPlan extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'notify:operators';


    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Уведомить операторов за сутки до плана работ';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
        //
        $tomorrow = Carbon::tomorrow()->toDateString();
        $plans = PointPlan::with('point', 'operator')
            ->whereDate('day', $tomorrow)
            ->whereNotNull('operator_id')
            ->get();


            foreach ($plans as $plan) {
                $operator = $plan->operator;

                if ($operator) {
                    $operator->userNotifications()->create([
                        'title' => 'Напоминание о выезде',
                        'content' => "Напоминаем: завтра вы должны выехать на ПУИДД {$plan->point->name} ({$plan->day}) с {$plan->timeStart} до {$plan->timeEnd}.",
                    ]);
                }
            }

        $this->info("Операторы уведомлены на {$tomorrow}");
    }
    public function schedule(Schedule $schedule): void
    {
        $schedule->dailyAt('09:00');
    }
}
