<?php

namespace App\Console\Commands;

use App\Models\RequestSet;
use Illuminate\Console\Command;

class RequestCopyPoints extends Command
{
    protected $signature   = 'request:copy-points
                              {from : ID заявки-источника}
                              {to   : ID заявки-приёмника}
                              {--replace : сначала очистить точки у приёмника}';

    protected $description = 'Копирует точки из одной заявки в другую';

    public function handle(): int
    {
        $from = RequestSet::find($this->argument('from'));
        $to   = RequestSet::find($this->argument('to'));

        if (!$from || !$to) {
            $this->error('Обе заявки должны существовать');
            return self::FAILURE;
        }

        $points = $from->points()->pluck('points.id');

        if ($points->isEmpty()) {
            $this->warn('У исходной заявки нет точек');
            return self::SUCCESS;
        }

        if ($this->option('replace')) {
            $to->points()->sync($points);              // стереть старые, записать новые
        } else {
            $to->points()->syncWithoutDetaching($points);
        }

        $this->info("Скопировано точек: {$points->count()}");

        return self::SUCCESS;
    }
}
