<?php

namespace App\Exports;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Events\BeforeWriting;
use Maatwebsite\Excel\Files\LocalTemporaryFile;
use Maatwebsite\Excel\Excel;

class ScheduleTemplateExport implements FromCollection, WithEvents, WithCustomStartCell
{
    protected Collection $rows;
    protected string $templatePath;
    protected string $startCell;
    protected string $districtName;
    protected string $actDate;
    protected string $startWork;
    protected string $endWork;
    protected int        $pointsCount;
    protected string $managerName;

    /**
     * @param Collection|array $rows
     * @param string $templatePath
     * @param string $startCell
     * @param string $districtName
     */
    public function __construct(
        $rows,
        string $templatePath,
        string $startCell = 'A1',
        string $districtName = '',
        string $actDate = '',
        string $startWork = '',
        string $endWork = '',
        int    $pointsCount  = 0,
        string $managerName = ''
    )
    {
        $this->rows = $rows instanceof Collection ? $rows : collect($rows);
        $this->templatePath = $templatePath;
        $this->startCell = $startCell;
        $this->districtName = $districtName;
        $this->actDate = $actDate;
        $this->startWork    = $startWork;
        $this->endWork      = $endWork;
        $this->pointsCount  = $pointsCount;
        $this->managerName = $managerName;
    }

    public function startCell(): string
    {
        return $this->startCell;
    }

    public function collection()
    {
        return $this->rows;
    }

    public function registerEvents(): array
    {
        return [
            BeforeWriting::class => function (BeforeWriting $event) {
                // 1) Переоткрываем книгу из шаблона
                $event->writer->reopen(
                    new LocalTemporaryFile($this->templatePath),
                    Excel::XLSX
                );

                // 2) Достаем сам Spreadsheet
                $sheet = $event->writer
                    ->getDelegate()
                    ->getActiveSheet();

                // 3) вставляем текст
                $sheet->setCellValue('C7', 'АО "Оренбургремдорстрой"');
                $sheet->setCellValue('C9', 'ООО "ИТБ"');
                $sheet->setCellValue('C11', 'Выполнение работ по учету интенсивности движения и состава транспортных потоков на автомобильных дорогах общего пользования регионального и межмуниципального значения Оренбургской области');
                if ($this->districtName == '') {
                    $sheet->setCellValue('C13', 'Выполнение работ по учету интенсивности движения и состава транспортных потоков на автомобильных дорогах общего пользования регионального и межмуниципального значения Оренбургской области.');
                }else {
                    $sheet->setCellValue('C13', 'Выполнение работ по учету интенсивности движения и состава транспортных потоков на автомобильных дорогах общего пользования регионального и межмуниципального значения Оренбургской области, '.$this->districtName);
                }

                // ОКПО Генподрядчика
                $sheet->setCellValue('N7', '79258606');
                // ОКПО Субподрядчика
                $sheet->setCellValue('N9', '05480625');
                //Номер договора
                $sheet->setCellValue('N14', '20-13/8с-КСМП25');
                // Дата договора
                $sheet->setCellValue('N15', '14.04.2025');
                // Дата составления
                $sheet->setCellValue('K20', $this->actDate);
                // Отчетный период
                $sheet->setCellValue('M20', $this->startWork);
                $sheet->setCellValue('O20', $this->endWork);
                $sheet->setCellValue('F32', $this->pointsCount);

                // Подписи: если район не выбран — иного начальника и ФИО
                if ($this->districtName === '') {
                    $sheet->setCellValue('C47', 'Начальник отдела ПТО АО "Оренбургремдорстрой"');
                    $sheet->setCellValue('E47', 'Зайцева Ксения Петровна');
                } else {
                    $sheet->setCellValue('C45', 'Районный менеджер ООО "ИТБ"');
                    $sheet->setCellValue('E45', $this->managerName);
                }
            },
        ];
    }
}
