<?php
namespace App\Exports;

use App\Services\TrafficReportCalculator;
use Maatwebsite\Excel\Concerns\{
    FromArray,
    WithHeadings,
    WithEvents,
    WithTitle,
    ShouldAutoSize
};
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

class TrafficReportExport implements FromArray, WithHeadings
{
    protected $plan;

    public function __construct($plan)
    {
        $this->plan = $plan;
    }

    public function title(): string
    {
        return 'Отчёт по интенсивности';
    }

    public function headings(): array
    {
        // Здесь формируем многострочные заголовки,
        // например:
        return [
            [
                'Место учета, км', '',
                'Границы перегона, км', '',
                'Протяженность, км', '', '', '', '',
                'Максимальная интенсивность за год', '', '', '', ''
            ],
            [
                '', '', 'от',
                'до', '',
                'Кол-во лёгких, сут',
                'Кол-во тяжёлых, сут',
                'Всего, сут',
                'Приведено к легк. авт.',
                'Часовая, шт/ч',
                'То же, шт/ч',
                'N50, шт/ч',
                'Суточная, шт/сут'
            ]
        ];
    }

    public function array(): array
    {
        $calc = (new TrafficReportCalculator($this->plan))->calculate();

        $rows = [];
        foreach ($calc['detail'] as $type => $d) {
            $rows[] = [
                $this->plan->point->km,                        // Место учёта
                '',                                           // (слева пусто, если не нужно)
                $this->plan->segment_start,                   // от
                $this->plan->segment_end,                     // до
                $this->plan->segment_length,                  // длина
                round($d['light_daily'],2),                  // лёгкие
                round($d['heavy_daily'],2),                  // тяжёлые
                round($d['total_daily'],2),                  // всего
                round($d['to_car_daily'],2),                 // приведено
                round($d['max_hour'],2),                     // часовая
                round($d['max_hour_to_car'],2),              // часовая привед.
                round($d['N50'],2),                          // N50
                round($d['Ncs'],2),                          // суточная
            ];
        }
        // итоговая строка
        $rows[] = [
            'Итого', '', '', '', '',
            round($calc['sum_light'],2),
            round($calc['sum_heavy'],2),
            round($calc['sum_total'],2),
            round($calc['sum_to_car'],2),
            '', '', '', round($calc['sum_Ncs'],2),
        ];

        return $rows;
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function(AfterSheet $event) {
                // Здесь можно объединить ячейки заголовков,
                // применить жирный шрифт, отцентровать и т.п.
                $sheet = $event->sheet->getDelegate();
                // Пример: объединить первую строку A1:D1
                $sheet->mergeCells('A1:B1');
                // Стили
                $sheet->getStyle('A1:M2')->getFont()->setBold(true);
                $sheet->getStyle('A3:M'.($sheet->getHighestRow()))
                    ->getAlignment()->setVertical(Alignment::VERTICAL_CENTER);
            },
        ];
    }
}
