<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    // Получить список уведомлений текущего пользователя
    public function index(Request $request)
    {
        $notifications = Notification::forUser($request->user()->id)->get();

        return response()->json($notifications);
    }

    // Пометить конкретное уведомление как прочитанное
    public function markAsRead($id, Request $request)
    {
        $notification = Notification::where('id', $id)
            ->where('user_id', $request->user()->id)
            ->firstOrFail();

        $notification->update([
            'is_read' => true,
        ]);

        return response()->json(['status' => 'success']);
    }
}
