<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Validation\Rules;
use Illuminate\Http\JsonResponse;

class UserController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    /**
     * Возвращает публичный и зашифрованный приватный ключ текущего аутентифицированного пользователя.
     * Внимание: вывод приватного ключа используется только для отладки!
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getKeys(Request $request)
    {
        // Получаем аутентифицированного пользователя
        $user = $request->user();

        // Возвращаем данные в виде JSON
        return response()->json([
            'public_key'  => $user->public_key,
            'private_key' => $user->private_key,
        ]);
    }

    public function changePassword(Request $request): JsonResponse
    {
        $request->validate([
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = $request->user();
        $user->password = bcrypt($request->password);
        $user->save();

        return response()->json([
            'message' => 'Пароль успешно изменён',
        ]);
    }
}
