<?php

namespace App\Http\Controllers;
use App\Models\District;
use App\Models\SchedulePlan;
use App\Models\User;
use Illuminate\Http\JsonResponse;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
abstract class Controller extends BaseController
{
    use AuthorizesRequests, ValidatesRequests;
    protected function normalizeValue($value): string
    {
        return trim(strtolower((string) $value));
    }
    public function verify(SchedulePlan $plan): JsonResponse
    {
        $subgroup_manager = User::find($plan->subgroup_manager_id);

        $isValid = openssl_verify(
            $plan->hash,
            base64_decode($plan->signature),
            $subgroup_manager->public_key,
            OPENSSL_ALGO_SHA256
        );

        return response()->json([
            'valid' => $isValid === 1,
        ]);
    }


    protected function getAllowedDistrictIdsForCurrentUser(): array
    {
        /** @var \App\Models\User $user */
        $user = auth()->user();

        // Суперадмин (или Администратор) видит все
        if ($user->hasRole('Администратор') || $user->hasRole('Разработчик')) {
            return District::pluck('id')->all();
        }

        // Заказчик — тоже все активные районы (или любые, как вам нужно)
        if ($user->hasRole('Заказчик')) {
            return District::pluck('id')->all();
        }

        // Региональный менеджер
        if ($user->hasRole('Региональный менеджер')) {
            $regionIds = $user->managedRegions()->pluck('id');
            return District::whereIn('region_id', $regionIds)->pluck('id')->all();
        }

        // Менеджер группы
        if ($user->hasRole('Менеджер группы')) {
            return District::where('group_manager_id', $user->id)->pluck('id')->all();
        }

        // Менеджер подгруппы
        if ($user->hasRole('Менеджер подгруппы')) {
            return District::where('subgroup_manager_id', $user->id)->pluck('id')->all();
        }

        return District::pluck('id')->all();
    }

}
