<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Notifications\DatabaseNotification;

class NotificationController extends Controller
{
    /**
     * Display a paginated list of the authenticated user's notifications.
     *
     * @param  Request  $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function index(Request $request)
    {
        $user = $request->user();
        // Получаем все уведомления пользователя
        $notifications = $user->notifications()->paginate(15);

        return response()->json($notifications);
    }

    /**
     * Mark a specific notification as read.
     *
     * @param  Request  $request
     * @param  string  $id  ID уведомления
     * @return \Illuminate\Http\JsonResponse
     */
    public function markAsRead(Request $request, $id)
    {
        $user = $request->user();

        // Находим уведомление в наборе уведомлений пользователя
        $notification = $user->notifications()->where('id', $id)->firstOrFail();

        // Если используется DatabaseNotification, есть метод markAsRead
        if (method_exists($notification, 'markAsRead')) {
            $notification->markAsRead();
        } else {
            // Иначе ручная отметка
            $notification->read_at = now();
            $notification->save();
        }

        return response()->json([
            'message' => 'Уведомление было помечено как прочитанное.',
        ]);
    }
}
