<?php

namespace App\Http\Controllers;

use App\Models\Role\Permission;
use Illuminate\Http\Request;

class PermissionController extends Controller
{
    // GET /api/permissions
    public function index()
    {
        return response()->json(Permission::all());
    }

    // POST /api/permissions
    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|unique:permissions,name',
        ]);

        $perm = Permission::create($data);
        return response()->json($perm, 201);
    }

    // GET /api/permissions/{permission}
    public function show(Permission $permission)
    {
        return response()->json($permission);
    }

    // PATCH /api/permissions/{permission}
    public function update(Request $request, Permission $permission)
    {
        $data = $request->validate([
            'name' => 'required|string|unique:permissions,name,' . $permission->id,
        ]);

        $permission->update($data);
        return response()->json($permission);
    }

    // DELETE /api/permissions/{permission}
    public function destroy(Permission $permission)
    {
        $permission->delete();
        return response()->json(null, 204);
    }
}
