<?php
namespace App\Http\Controllers;

use App\Http\Requests\ManagersRequest;
use App\Models\District;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class RefController extends Controller
{
    /** GET /api/ref/managers */
    public function managers(Request $request)
    {
        $users = User::query()
            ->select('id', 'first_name', 'middle_name', 'last_name')
            ->when($request->level === 'group',    fn ($q) => $q->groupManagers())
            ->when($request->level === 'subgroup', fn ($q) => $q->subgroupManagers())
            ->orderBy('first_name')
            ->orderBy('middle_name')
            ->orderBy('last_name')
            ->get()
            ->map(fn ($u) => ['id' => $u->id, 'fullName' => $u->full_name]);

        return response()->json($users);
    }

    /** GET /api/ref/districts */
    public function districts()
    {
        return \App\Models\District::select('id', 'name')->orderBy('name')->get();
    }
}
