<?php

namespace App\Http\Controllers;

use App\Models\RequestPlanSignature;
use App\Models\RequestSet;
use Illuminate\Http\Request;

class RequestPlanSignatureController extends Controller
{
    public function store(Request $r, RequestSet $requestModel)
    {
        $r->validate([
            'month'      => 'required|integer|min:1|max:12',
            'year'       => 'required|integer|min:2000',
        ]);

        $requestId = $requestModel->id;
        // Проверяем право:
        if (! auth()->user()->hasPermission('sign-plan-chart')) {
            abort(403, 'У вас нет права подписывать план-график.');
        }

        // Не дать подписать повторно
        $exists = RequestPlanSignature::where([
            'request_id' => $requestModel->id,
            'month'      => $r->month,
            'year'       => $r->year,
        ])->exists();

        if ($exists) {
            abort(422, 'План-график за этот месяц уже подписан.');
        }

        $sig = RequestPlanSignature::create([
            'request_id' => $requestModel->id,
            'month'      => $r->month,
            'year'       => $r->year,
            'signed_by'  => auth()->id(),
            'signed_at'  => now(),
            'is_signed'  => true,
            // 'signature_public_key' => ... // если нужно
        ]);

        return response()->json([
            'success' => true,
            'message' => 'План-график подписан.'
        ], 200);
    }
}

