<?php
namespace App\Http\Controllers;

use App\Models\Role\Role;
use Illuminate\Http\Request;
use App\Models\Role\Permission;

class RoleController extends Controller
{
    public function index(Request $request)
    {
        // всегда возвращаем роли с правами
        $roles = Role::with('permissions')->get();
        return response()->json($roles);
    }

    /**
     * POST /api/roles/{role}/permissions/{perm}
     * Назначить право $perm роли $role
     */
    public function attachPermission(Role $role, Permission $perm)
    {
        $role->permissions()->syncWithoutDetaching($perm->id);

        // Обновим и вернём актуальный список прав роли
        $role->load('permissions');
        return response()->json([
            'role' => $role,
            'message' => "Permission '{$perm->name}' attached to role '{$role->name}'."
        ]);
    }

    /**
     * DELETE /api/roles/{role}/permissions/{perm}
     * Снять право $perm с роли $role
     */
    public function detachPermission(Role $role, Permission $perm)
    {
        $role->permissions()->detach($perm->id);

        // Обновим и вернём актуальный список прав роли
        $role->load('permissions');
        return response()->json([
            'role' => $role,
            'message' => "Permission '{$perm->name}' detached from role '{$role->name}'."
        ]);
    }
}
