<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class RegisterUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'login'        => ['required','string','lowercase','max:255','unique:users,login'],
            'password'     => ['required','confirmed', Password::defaults()],
            'first_name'   => ['required','string','min:2','max:255'],
            'last_name'    => ['required','string','min:2','max:255'],
            'middle_name'  => ['required','string','min:2','max:255'],
            'role_id'      => ['required','integer','exists:roles,id'],
            'position'     => ['required','string','min:2','max:255'],
            'birthday'     => ['required','date'],
        ];
    }
}
