<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreMeasurementRecordsRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'direction'             => 'required|boolean',
            'weather'               => 'required|string|in:Ясно,Пасмурно,Дождь,Снег',
            'lanes_count'           => 'nullable|integer|min:1|max:10',
            'records'               => 'required|array',
            'records.*.category_key'=> 'required|string|exists:vehicle_categories,key',
            'records.*.hour'        => 'required|date_format:H:i',
            'records.*.count'       => 'required|integer|min:0',
            'is_manual'             => 'required|boolean',
        ];
    }

    public function authorize(): bool
    {
        return true;
    }
}
