<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DistrictResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request): array
    {
        return [
            'id'   => $this->id,
            'name' => $this->name,

            'region' => [
                'id'   => $this->region->id,
                'name' => $this->region->name,
            ],
            'group_manager_id' => optional($this->groupManager)->id,
            'subgroup_manager_id' => optional($this->subgroupManager)->id,

            'group_manager' => $this->when(
                $this->relationLoaded('groupManager') && $this->groupManager,
                fn () => new ManagerResource($this->groupManager)
            ),
            'subgroup_manager' => $this->when(
                $this->relationLoaded('subgroupManager') && $this->subgroupManager,
                fn () => new ManagerResource($this->subgroupManager)
            ),
        ];
    }
}
