<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class DistrictShortResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'     => $this->id,
            'name'   => $this->name,
            'subgroup_manager_id' => $this->subgroup_manager_id,
            'region' => [
                'id'   => $this->region->id ?? null,
                'name' => $this->region->name ?? null,
            ],
        ];
    }
}
