<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PointMapResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        return [
            'id'             => $this->id,
            'latitude'       => $this->latitude,
            'longitude'      => $this->longitude,
            'name'           => $this->name,
            'district_id'    => $this->district_id,
            'length'         => $this->length,
            'road_category'  => $this->road_category,
            'accounting_point' => $this->accounting_point,
            'record_number'  => $this->record_number,
            'monitoring_freq'=> $this->monitoring_freq,
            'accounting_flag'=> $this->accounting_flag,
            'is_active'      => $this->is_active,
            // geojson только если явно нужно
            'geojson'        => $request->filled('district_id') ? $this->geojson : null,
            // Вложенные связи
            'district'       => new DistrictShortResource($this->whenLoaded('district')),
            'plans'          => PlanResource::collection($this->whenLoaded('plans')),
            'requests'       => RequestShortResource::collection($this->whenLoaded('requests')),
        ];
    }
}
