<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PointPlanResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'day' => $this->day->format('Y-m-d'),
            'timeStart' => $this->timeStart?->format('H:i'),
            'timeEnd' => $this->timeEnd?->format('H:i'),
            'request_id'          => $this->request_id,
            'point' => [
                'id'               => $this->point->id,
                'name'             => $this->point->name,
                'record_number'    => $this->point->record_number,
                'monitoring_freq'  => $this->point->monitoring_freq,
                'accounting_flag'  => $this->point->accounting_flag,
                'accounting_point' => $this->point->accounting_point,         //  км дороги
                'latitude'         => $this->point->latitude,                 //  пункт учета
                'longitude'        => $this->point->longitude,
                'road_category'    => $this->point->road_category,            //  категория дороги
                'road_subcategory' => $this->point->road_subcategory,
                'request_label'    => $this->point->request_label,
                'district' => [
                    'id' => $this->point->district->id,
                    'name' => $this->point->district->name,
                    'region' => [
                        'id' => $this->point->district->region->id,
                        'name' => $this->point->district->region->name,
                    ],
                    'manager' => $this->point->district->groupManager ? [
                        'id' => $this->point->district->groupManager->id,
                        'first_name' => $this->point->district->groupManager->first_name,
                        'last_name' => $this->point->district->groupManager->last_name,
                        'middle_name' => $this->point->district->groupManager->middle_name,
                    ] : null,
                ],
            ],
            'subgroup_manager' => $this->subgroupManager ? [
                'id' => $this->subgroupManager->id,
                'first_name' => $this->subgroupManager->first_name,
                'last_name' => $this->subgroupManager->last_name,
                'middle_name' => $this->subgroupManager->middle_name,
            ] : null,
            'counter' => $this->counter ? [
                'id' => $this->counter->id,
                'first_name' => $this->counter->first_name,
                'last_name' => $this->counter->last_name,
            ] : null,
            'schedule' => [
                'id' => $this->schedule->id,
                'year' => $this->schedule->year,
            ],
        ];
    }
}
