<?php
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PointResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'               => $this->id,
            'name'             => $this->name,
            'latitude'         => $this->latitude,
            'longitude'        => $this->longitude,
            'district_id'      => $this->district_id,
            // вложенный ресурс района, если загружен
            'district'         => new DistrictResource($this->whenLoaded('district')),
            'road_category'    => $this->road_category,
            // новые поля:
            'length'           => $this->length,
            'accounting_point' => $this->accounting_point,
            'segment_from'     => $this->segment_from,
            'segment_to'       => $this->segment_to,
            // (при желании можно вернуть record_number, accounting_flag и т.п.)
            'record_number'    => $this->record_number,
            'accounting_flag'  => $this->accounting_flag,
        ];
    }
}
