<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SchedulePointResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'length' => $this->length,
            'road_category' => $this->road_category,
            'district_id' => $this->district_id,
            'plans' => $this->plans->map(function ($plan) {
                return [
                    'day' => $plan->day,
                    'timeStart' => $plan->timeStart,
                    'timeEnd' => $plan->timeEnd,
                    'subgroup_manager' => $plan->subgroupManager ? [
                        'id' => $plan->subgroupManager->id,
                        'name' => $plan->subgroupManager->name,
                    ] : null,
                    'counter' => $plan->counter ? [
                        'id' => $plan->counter->id,
                        'name' => $plan->counter->name,
                    ] : null,
                ];
            }),
        ];
    }
}
