<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'          => $this->id,
            'login'       => $this->login,
            'first_name'  => $this->first_name,
            'middle_name' => $this->middle_name,
            'last_name'   => $this->last_name,
            'position'    => $this->position,
            'birthday'    => $this->birthday,
            'role'        => [
                'id'   => $this->role?->id,
                'name' => $this->role?->name,
            ],
            'is_active'   => $this->is_active,
            'created_at'  => $this->created_at,
        ];
    }
}
