<?php

namespace App\Models;

use Spatie\Activitylog\Models\Activity as BaseActivity;

class Activity extends BaseActivity
{
    public function getReadableDescriptionAttribute(): string
    {
        if ($this->description) {
            return $this->description;
        }
        $changes = $this->properties->toArray();
        if (!isset($changes['old'])) {
            return "{$this->log_name} был {$this->event}";
        }
        $parts = [];
        foreach ($changes['old'] as $k => $old) {
            $new = $changes['attributes'][$k] ?? null;
            $parts[] = "{$k}: «{$old}»→«{$new}»";
        }
        return "{$this->log_name} {$this->event} — " . implode(', ', $parts);
    }
}
